package mole.entities.decors 
{
	import net.flashpunk.Entity;
	import net.flashpunk.FP;
	import net.flashpunk.graphics.Spritemap;
	import flash.utils.ByteArray;
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CDecor extends Entity 
	{
		
		public function CDecor(_nType:int, _nPosX:int, _nPosY:int)
		{
			LoadXML(CDecorAssets.s_DecorsConf[_nType]);
			
			x = _nPosX;
			y = _nPosY;			
		}
		
		private function LoadXML(_Conf:Class):void
		{
			// Lecture du fichier XML.
			var file:ByteArray = new _Conf;
			var str:String = file.readUTFBytes( file.length );
			var xml:XML = new XML( str );
				
			// creation des animations
			if (xml.animations)
			{
				for each (var animations:XML in xml.animations)
				{
					// <animations width="48" height="32">
					width = animations.@width;
					height = animations.@height;
					var spriteAnim:Spritemap = new Spritemap(CDecorAssets.s_DecorsPng[xml.animations.@id], animations.@width, animations.@height);					
						
					// on parcours toute les animations.
					for each(var anim:XML in animations.anim)
					{
						// <anim name="idle" tile="0, 1, 2, 3, 4, 5" speed="20" loop="true" />
						spriteAnim.add(anim.@name, (anim.@tile).split(", "), anim.@speed, true);
					}
					
					spriteAnim.alpha = 0.5;
					graphic = spriteAnim;
				}
				
				PlayAnim("idle");
			}
		}
		
		public function PlayAnim(_sName:String):void
		{
			(graphic as Spritemap).play(_sName);
		}
	}

}